package org.msh.tb.bd.tbforms.indicator.tb11;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb11.TBForm11Block2Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.TbFormField;
import org.msh.tb.indicators.core.Indicator2D;

import java.util.List;
import java.util.Map;

/**
 * Mounts TB 11 Block 2 Indicator
 */
@Name("TBForm11Block2Home")
public class TBForm11Block2Home extends Indicator2D {

    TbFormQuery formQuery;

    @In(create=true) protected Map<String, String> messages;

	@Override
	protected void createIndicators() {
        initializeInterfaceTableRow();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        for(Object[] o : result) {
            TbFormField field = (TbFormField) o[0];
            Integer qtd = (Integer) o[1];

            switch (field) {
                case TB11_IPT_COLUMN1_MALE:
                    addValue("M1", "M", "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB11_IPT_COLUMN1_FEMALE:
                    addValue("F1", "F", "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB11_IPT_COLUMN2_MALE:
                    addValue("M2", "M", "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB11_IPT_COLUMN2_FEMALE:
                    addValue("F2", "F", "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB11_IPT_COLUMN3_MALE:
                    addValue("M3", "M", "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB11_IPT_COLUMN3_FEMALE:
                    addValue("F3", "F", "nodisplayname_line1", qtd.floatValue());
                    break;
            }
        }
	}

    /**
     * Initialize the interface table. All cells should be there also if it's result is zero.
     */
    private void initializeInterfaceTableRow(){
        addValue("M1", "M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F1", "F", "nodisplayname_line1", new Float(0).floatValue());
        addValue("M2", "M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F2", "F", "nodisplayname_line1", new Float(0).floatValue());
        addValue("M3", "M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F3", "F", "nodisplayname_line1", new Float(0).floatValue());
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm11Block2Query();
        }

        return formQuery;
    }
}
